/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.v1_15_R1;

import com.andavin.images.PacketListener;
import com.andavin.images.image.CustomImageSection;
import com.andavin.images.v1_15_R1.PlayerConnectionProxy;
import com.andavin.reflect.Reflection;
import com.andavin.util.Logger;
import com.andavin.util.Scheduler;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.server.v1_15_R1.EnumHand;
import net.minecraft.server.v1_15_R1.ItemStack;
import net.minecraft.server.v1_15_R1.ItemWorldMap;
import net.minecraft.server.v1_15_R1.NBTTagCompound;
import net.minecraft.server.v1_15_R1.PacketPlayInSetCreativeSlot;
import net.minecraft.server.v1_15_R1.PacketPlayInUseEntity;
import net.minecraft.server.v1_15_R1.PlayerConnection;
import net.minecraft.server.v1_15_R1.World;
import net.minecraft.server.v1_15_R1.WorldMap;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

class PacketListener
extends com.andavin.images.PacketListener<PacketPlayInUseEntity, PacketPlayInSetCreativeSlot> {
    private static final Field ENTITY_ID = Reflection.findField(PacketPlayInUseEntity.class, "a");

    PacketListener() {
    }

    @Override
    protected void setEntityListener(Player player, PacketListener.ImageListener listener) {
        PlayerConnection connection = ((CraftPlayer)player).getHandle().playerConnection;
        connection.networkManager.setPacketListener((net.minecraft.server.v1_15_R1.PacketListener)new PlayerConnectionProxy(connection, listener, this));
    }

    @Override
    protected void handle(Player player, PacketListener.ImageListener listener, PacketPlayInUseEntity packet) {
        PacketListener.call(player, (Integer)Reflection.getFieldValue(ENTITY_ID, packet), packet.b() == PacketPlayInUseEntity.EnumEntityUseAction.ATTACK ? PacketListener.InteractType.LEFT_CLICK : PacketListener.InteractType.RIGHT_CLICK, packet.c() == EnumHand.MAIN_HAND ? PacketListener.Hand.MAIN_HAND : PacketListener.Hand.OFF_HAND, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle(Player player, PacketPlayInSetCreativeSlot packet) {
        CustomImageSection section;
        int mapId;
        ItemStack item = packet.getItemStack();
        NBTTagCompound tag = item.getTag();
        if (tag != null && (mapId = tag.getInt("map")) >= 1000000 && (section = PacketListener.getImageSection(mapId)) != null) {
            AtomicBoolean complete = new AtomicBoolean();
            Scheduler.sync(() -> {
                try {
                    WorldMap map = ItemWorldMap.getSavedMap((ItemStack)item, (World)((CraftPlayer)player).getHandle().getWorld());
                    map.locked = true;
                    map.scale = (byte)3;
                    map.track = false;
                    map.unlimitedTracking = true;
                    map.colors = section.getPixels();
                }
                finally {
                    complete.set(true);
                    AtomicBoolean atomicBoolean = complete;
                    synchronized (atomicBoolean) {
                        complete.notify();
                    }
                }
            });
            AtomicBoolean atomicBoolean = complete;
            synchronized (atomicBoolean) {
                while (!complete.get()) {
                    try {
                        complete.wait();
                    }
                    catch (InterruptedException e) {
                        Logger.severe(e);
                    }
                }
            }
        }
    }
}

